package java.game.cars;

import java.game.*;
import java.util.*;
import java.game.parts.*;
import java.game.parts.enginepart.airfueldeliverysystem.*;

public class Whisper_chassis extends Whisper_models
{
	public Whisper_chassis( int id )
	{
		super( id );
		carCategory = PACKAGE;
		
		vehicleName = vendorName = "Whisper";
		name = getName();
		
		rID_blueprint = cars.cat_04.Whisper:0x018Ar;
		defColorIndex = GameLogic.CARCOLOR_BLUE;
		
		game_version = 2.31;
		ban_mufflers = own_suspension = allow_missing_seats = 1;

		value = 48000;
 
		fully_stripped_drag = 0.55;
		min_drag = 0.356;
		drag_reduction_mul = 1.0;
		
		parts_shop_sml = new int[2];
		parts_shop_sml[0] = cars.cat_04.Whisper:0x01F4r; //Left taillight dark
		parts_shop_sml[1] = cars.cat_04.Whisper:0x0202r; //right taillight dark
		
		parts_shop_big = new int[2];
		parts_shop_big[0] = cars.cat_04.Whisper:0x010Br; //Left exhaust
		parts_shop_big[1] = cars.cat_04.Whisper:0x010Ar; //right exhaust
	}

	public void addStockParts( Descriptor desc )
	{
		int actcolor = desc.color;
		float optical = desc.optical;
		float power = desc.power;
		
		super.addStockParts( actcolor, optical, power );

		float part_random;

		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_04.whisper:0x000000E5r, "F windshield", actcolor, optical, power );
			addPart( cars.cat_04.whisper:0x000000FCr, "R windshield", actcolor, optical, power );
			addPart( cars.cat_04.whisper:0x000000E6r, "FL door", actcolor, optical, power );
			addPart( cars.cat_04.whisper:0x000000E7r, "FL seat", actcolor, optical, power );
			addPart( cars.cat_04.whisper:0x000000E9r, "FR door", actcolor, optical, power );
			addPart( cars.cat_04.whisper:0x000000EEr, "L headlights", actcolor, optical, power );
			addPart( cars.cat_04.whisper:0x000000F4r, "L taillights", actcolor, optical, power );
			addPart( cars.cat_04.whisper:0x000000F8r, "R headlights", actcolor, optical, power );
			addPart( cars.cat_04.whisper:0x000000FDr, "trunk", actcolor, optical, power );
			addPart( cars.cat_04.whisper:0x00000102r, "R taillights", actcolor, optical, power );
			addPart( cars.cat_04.whisper:0x00000103r, "FR seat", actcolor, optical, power );
			addPart( cars.cat_04.whisper:0x0000010Ar, "R exhaust pipe", actcolor, optical, power );
			addPart( cars.cat_04.whisper:0x0000010Br, "L exhaust pipe", actcolor, optical, power );
			if ( power >= 1.333 )
				addPart( cars.cat_04.whisper:0x00000105r, "L ram air intake", actcolor, optical, power );
			if ( power >= 1.333 )
				addPart( cars.cat_04.whisper:0x00000104r, "R ram air intake", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) addPart( cars.cat_04.whisper:0x000000E5r, "F windshield", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.whisper:0x000000FCr, "R windshield", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.whisper:0x000000E6r, "FL door", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.whisper:0x000000E7r, "FL seat", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.whisper:0x000000E9r, "FR door", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.whisper:0x000000EEr, "L headlights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.whisper:0x000000F4r, "L taillights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.whisper:0x000000F8r, "R headlights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.whisper:0x000000FDr, "trunk", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.whisper:0x00000102r, "R taillights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.whisper:0x00000103r, "FR seat", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.whisper:0x0000010Ar, "R exhaust pipe", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.whisper:0x0000010Br, "L exhaust pipe", actcolor, optical, power );
			if ( power >= 1.333 )
				if ( optical >= random() ) addPart( cars.cat_04.whisper:0x00000105r, "L ram air intake", actcolor, optical, power );
			if ( power >= 1.333 )
				if ( optical >= random() ) addPart( cars.cat_04.whisper:0x00000104r, "R ram air intake", actcolor, optical, power );
		}

		// parts that have multiple appearance //
		if ( optical <= 1.0 )
		{
			if ( optical >= random() ) addPart( cars.cat_04.whisper:0x000000E2r, "F bumper", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.whisper:0x000000F1r, "L sideskirt", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.whisper:0x000000F5r, "R bumper", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.whisper:0x000000F9r, "R sideskirt", actcolor, optical, power );
		} else
		{
			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_04.whisper:0x000000E4r, "F bumper 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_04.whisper:0x000000E3r, "F bumper 2", actcolor, optical, power ); else
			addPart( cars.cat_04.whisper:0x000000E2r, "F bumper", actcolor, optical, power );

			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_04.whisper:0x000000F3r, "L sideskirt 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_04.whisper:0x000000F2r, "L sideskirt 2", actcolor, optical, power ); else
			addPart( cars.cat_04.whisper:0x000000F1r, "L sideskirt", actcolor, optical, power );

			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_04.whisper:0x000000FBr, "R sideskirt 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_04.whisper:0x000000FAr, "R sideskirt 2", actcolor, optical, power ); else
			addPart( cars.cat_04.whisper:0x000000F9r, "R sideskirt", actcolor, optical, power );

			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_04.whisper:0x000000F7r, "R bumper 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_04.whisper:0x000000F6r, "R bumper 2", actcolor, optical, power ); else
			addPart( cars.cat_04.whisper:0x000000F5r, "R bumper", actcolor, optical, power );
		}

		addPart( cars.cat_04.whisper:0x000000FEr, "FL suspension" );
		addPart( cars.cat_04.whisper:0x000000FFr, "FR suspension" );
		addPart( cars.cat_04.whisper:0x00000100r, "RL suspension" );
		addPart( cars.cat_04.whisper:0x00000101r, "RR suspension" );

		if ( optical < 1.0 )
		{
			addPart( parts.wheels_combo:0x000000B0r, "wheel" );
			addPart( parts.wheels_combo:0x000000B0r, "wheel" );
			addPart( parts.wheels_combo:0x000000B1r, "wheel" );
			addPart( parts.wheels_combo:0x000000B1r, "wheel" );

		} else
		{
			if ( random() > 0.5 ) // SI//
			{
				if ( (power+optical)*0.5 >= 1.666 ) // 255-21F 375-21R //
				{
					addPart( parts.wheels_combo:0x00000BB3r, "wheel" );
					addPart( parts.wheels_combo:0x00000BB3r, "wheel" );
					addPart( parts.wheels_combo:0x00000BB5r, "wheel" );
					addPart( parts.wheels_combo:0x00000BB5r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.333 ) // 255-21F 315-21R //
				{
					addPart( parts.wheels_combo:0x00000BB3r, "wheel" );
					addPart( parts.wheels_combo:0x00000BB3r, "wheel" );
					addPart( parts.wheels_combo:0x00000BB4r, "wheel" );
					addPart( parts.wheels_combo:0x00000BB4r, "wheel" );
				} else                             // 255-19F 315-19R //
				{
					addPart( parts.wheels_combo:0x000000B3r, "wheel" );
					addPart( parts.wheels_combo:0x000000B3r, "wheel" );
					addPart( parts.wheels_combo:0x000000B4r, "wheel" );
					addPart( parts.wheels_combo:0x000000B4r, "wheel" );
				}
			} else
			if ( random() > 0.5 ) // Sparkler //
			{
				if ( (power+optical)*0.5 >= 1.666 ) // 255-21F 375-21R //
				{
					addPart( parts.wheels_combo:0x00000BB6r, "wheel" );
					addPart( parts.wheels_combo:0x00000BB6r, "wheel" );
					addPart( parts.wheels_combo:0x00000BB8r, "wheel" );
					addPart( parts.wheels_combo:0x00000BB8r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.333 ) // 255-21F 315-21R //
				{
					addPart( parts.wheels_combo:0x00000BB6r, "wheel" );
					addPart( parts.wheels_combo:0x00000BB6r, "wheel" );
					addPart( parts.wheels_combo:0x00000BB7r, "wheel" );
					addPart( parts.wheels_combo:0x00000BB7r, "wheel" );
				} else                             // 255-19F 315-19R //
				{
					addPart( parts.wheels_combo:0x000000B6r, "wheel" );
					addPart( parts.wheels_combo:0x000000B6r, "wheel" );
					addPart( parts.wheels_combo:0x000000B7r, "wheel" );
					addPart( parts.wheels_combo:0x000000B7r, "wheel" );
				}
			} else                // Chromo //
			{
				if ( (power+optical)*0.5 >= 1.666 ) // 255-21F 375-21R //
				{
					addPart( parts.wheels_combo:0x00000BAAr, "wheel" );
					addPart( parts.wheels_combo:0x00000BAAr, "wheel" );
					addPart( parts.wheels_combo:0x00000BACr, "wheel" );
					addPart( parts.wheels_combo:0x00000BACr, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.333 ) // 255-21F 315-21R //
				{
					addPart( parts.wheels_combo:0x00000BAAr, "wheel" );
					addPart( parts.wheels_combo:0x00000BAAr, "wheel" );
					addPart( parts.wheels_combo:0x00000BABr, "wheel" );
					addPart( parts.wheels_combo:0x00000BABr, "wheel" );
				} else                             // 255-19F 315-19R //
				{
					addPart( parts.wheels_combo:0x000000AAr, "wheel" );
					addPart( parts.wheels_combo:0x000000AAr, "wheel" );
					addPart( parts.wheels_combo:0x000000ABr, "wheel" );
					addPart( parts.wheels_combo:0x000000ABr, "wheel" );
				}
			}
		}

		if ( power >= 1.4 ) // Bilstein pro racer //
		{
			addPart( parts.running_gear:0x000001F8r, "shock" );
			addPart( parts.running_gear:0x000001F8r, "shock" );
			addPart( parts.running_gear:0x000001F9r, "shock" );
			addPart( parts.running_gear:0x000001F9r, "shock" );
		} else
		if ( power >= 1.2 ) // Bilstein street racer //
		{
			addPart( parts.running_gear:0x000001F6r, "shock" );
			addPart( parts.running_gear:0x000001F6r, "shock" );
			addPart( parts.running_gear:0x000001F7r, "shock" );
			addPart( parts.running_gear:0x000001F7r, "shock" );
		} else
		if ( power >= 1.1 ) // Bilstein aftermarket //
		{
			addPart( parts.running_gear:0x000001EFr, "shock" );
			addPart( parts.running_gear:0x000001EFr, "shock" );
			addPart( parts.running_gear:0x000001F0r, "shock" );
			addPart( parts.running_gear:0x000001F0r, "shock" );
		} else                // stock //
		{
			addPart( parts.running_gear:0x000011FFr, "shock" );
			addPart( parts.running_gear:0x000011FFr, "shock" );
			addPart( parts.running_gear:0x000012FFr, "shock" );
			addPart( parts.running_gear:0x000012FFr, "shock" );
		}

		if ( power >= 1.25 ) // H&R pro racer 58000 Nm 10" //
		{
			addPart( parts.running_gear:0x0000021Fr, "spring" );
			addPart( parts.running_gear:0x0000021Fr, "spring" );
			addPart( parts.running_gear:0x00000220r, "spring" );
			addPart( parts.running_gear:0x00000220r, "spring" );
		} else
		if ( power >= 1.125 ) // H&R aftermarket 36000 Nm 11" //
		{
			addPart( parts.running_gear:0x000001BDr, "spring" );
			addPart( parts.running_gear:0x000001BDr, "spring" );
			addPart( parts.running_gear:0x000001BEr, "spring" );
			addPart( parts.running_gear:0x000001BEr, "spring" );
		} else                // stock 32000Nm 12" //
		{
			addPart( parts.running_gear:0x0000021Dr, "spring" );
			addPart( parts.running_gear:0x0000021Dr, "spring" );
			addPart( parts.running_gear:0x0000021Er, "spring" );
			addPart( parts.running_gear:0x0000021Er, "spring" );
		}

		if ( power >= 1.3 ) // Baer carbon 12.5"F 13.0"R //
		{
			addPart( parts.running_gear:0x000000E2r, "FL brake" );
			addPart( parts.running_gear:0x000000E5r, "FR brake" );
			addPart( parts.running_gear:0x000000FAr, "RL brake" );
			addPart( parts.running_gear:0x000000FFr, "RR brake" );
		} else
		if ( power >= 1.15 ) // Baer grooved 12.5"F 12.5"R //
		{
			addPart( parts.running_gear:0x00000147r, "FL brake" );
			addPart( parts.running_gear:0x00000149r, "FR brake" );
			addPart( parts.running_gear:0x0000014Cr, "RL brake" );
			addPart( parts.running_gear:0x0000014Er, "RR brake" );
		} else              // Baer drilled 12.5"F 12.5"R //
		{
			addPart( parts.running_gear:0x00000108r, "FL brake" );
			addPart( parts.running_gear:0x00000132r, "FR brake" );
			addPart( parts.running_gear:0x00000136r, "RL brake" );
			addPart( parts.running_gear:0x00000146r, "RR brake" );
		}

		if ( power >= 1.25 ) // supersport //
		{
			addPart( parts.running_gear:0x00000164r, "F swaybar" );
			addPart( parts.running_gear:0x00000181r, "R swaybar" );
		} else              // sport //
		{
			addPart( parts.running_gear:0x00000154r, "F swaybar" );
			addPart( parts.running_gear:0x0000015Cr, "R swaybar" );
		}

		int supercharged;
		float enginePow;
		
		if ( power >= 1.833 ) addPart( parts.engines.V10:0x0000000Ar, "8.4L copper coated V10 engine", actcolor, optical, (power-1.833)/0.166*2 ); else
		if ( power >= 1.666 ) addPart( parts.engines.V10:0x00000009r, "7.1L copper coated V10 engine", actcolor, optical, (power-1.666)/0.166*2 ); else
		if ( power >= 1.5 ) addPart( parts.engines.V10:0x00000008r, "6.8L alloy V10 engine", actcolor, optical, (power-1.5)/0.166*2 ); else
		if ( power >= 1.333 ) addPart( parts.engines.V10:0x00000007r, "5.9L alloy V10 engine", actcolor, optical, (power-1.333)/0.166*2 ); else
		if ( power >= 1.166 )
		{
			enginePow = (power-1.166)/0.166*2;
			addPart( parts.engines.V8:0x0000000Cr, "10.0L V8 engine", actcolor, optical, enginePow );
		} else
		if ( power >= 1 )
		{
			enginePow = (power-1)/0.166*2;
			addPart( parts.engines.V8:0x0000000Br, "8.5L V8 engine", actcolor, optical, enginePow );
		} else
		if ( power >= 0.833 )
		{
			enginePow = (1-power)/0.166*2;
			addPart( parts.engines.V8:0x0000000Ar, "6.5L V8 engine", actcolor, optical, enginePow );
		} else
		if ( power >= 0.666 )
		{
			enginePow = (0.833-power)/0.166*2;
			addPart( parts.engines.V8:0x00000009r, "5.7L V8 engine", actcolor, optical, enginePow );
		} else
		if ( power >= 0.5 )
		{
			enginePow = (0.666-power)/0.166*2;
			addPart( parts.engines.V8:0x00000008r, "5.0L V8 engine", actcolor, optical, enginePow );
		}
		
		if(enginePow >= 1.50) supercharged++; //EvilMcSheep: Or at least has the sc intake manifold, which brings the intake too high as well
		
		if ( power >= 1.35 ) addPart( parts:0x000000E9r, "silver battery" ); else
		addPart( parts:0x000000E8r, "blue battery" );
		
		if ( optical <= 1.0 )
		{
			if ( !supercharged && optical >= random() ) addPart( cars.cat_04.whisper:0x000000EBr, "hood", actcolor, optical, power );
		} else
		{
			if(!supercharged)
			{
				if ( optical-1 >= 0.6666 ) addPart( cars.cat_04.whisper:0x000000EDr, "hood 3", actcolor, optical, power ); else
				if ( optical-1 >= 0.3333 ) addPart( cars.cat_04.whisper:0x000000ECr, "hood 2", actcolor, optical, power ); else
				addPart( cars.cat_04.whisper:0x000000EBr, "hood", actcolor, optical, power );
			}
			else if ( optical >= 1.0 ) addPart( cars.cat_04.whisper:0x0000AFEBr, "hood 4", actcolor, optical, power ); //Newly-available at dealer in SL1R
		}
		addPart( cars.cat_04.Whisper:0x0000FFB4r, "steering wheel" );
	}
	
	public void setDrive(int fwd, int rwd, float drive_front)
	{
		if((fwd && !rwd) || (rwd && !fwd)) super.setDrive(0,1,0.0); //2WD all becomes RWD
		else super.setDrive(fwd, rwd, drive_front); //Leave AWD alone 
	}
}
